//
//  Recording_AudioViewController.m
//  Recording Audio
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Recording_AudioViewController.h"

@implementation Recording_AudioViewController

@synthesize audioRecorder;
@synthesize audioPlayer;

- (NSString *) audioRecordingPath{
  
  NSString *result = nil;
  
  NSArray *folders = 
  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, 
                                      NSUserDomainMask,
                                      YES);
  
  NSString *documentsFolder = [folders objectAtIndex:0];
  
  result = [documentsFolder 
            stringByAppendingPathComponent:@"Recording.m4a"];
  
  return result;
  
}

- (void)audioPlayerBeginInterruption:(AVAudioPlayer *)player{
  
  /* Sesja audio została przerwana. W tym miejscu odtwarzacz wstrzyma odtwarzanie treści audio. */
  
}

- (void)audioPlayerEndInterruption:(AVAudioPlayer *)player 
                         withFlags:(NSUInteger)flags{
  
  if (flags == AVAudioSessionInterruptionFlags_ShouldResume){
    [player play];
  }
  
}

- (void)audioPlayerDidFinishPlaying:(AVAudioPlayer *)player 
                       successfully:(BOOL)flag{
  
  if (flag){
    NSLog(@"Udało się poprawnie zatrzymać działanie odtwarzacza treści audio.");
  } else {
    NSLog(@"Nie udało się poprawnie zatrzymać działania odtwarzacza treści audio.");
  }
  
  if ([player isEqual:self.audioPlayer]){
    self.audioPlayer = nil;
  } else {
    /* To nie jest nasz odtwarzacz treści audio. */
  }
  
}

- (void)audioRecorderDidFinishRecording:(AVAudioRecorder *)recorder 
                           successfully:(BOOL)flag{
  
  if (flag){
    
    NSLog(@"Udało się zatrzymać proces nagrywania treści audio.");
    
    /* Spróbujemy teraz pobrać dane zapisane w pliku nagrania. */
    NSError *playbackError = nil;
    
    NSError *readingError = nil;
    NSData  *fileData = 
    [NSData dataWithContentsOfFile:[self audioRecordingPath]
                           options:NSDataReadingMapped
                             error:&readingError];
    
    /* Utworzenie odtwarzacza i rozpoczęcie odtwarzania zarejestrowanej treści audio. */
    self.audioPlayer = [[AVAudioPlayer alloc] initWithData:fileData
                                                     error:&playbackError];
    
    /* Czy udało się utworzyć odtwarzacz treści audio? */
    if (self.audioPlayer != nil){
      self.audioPlayer.delegate = self;
      
      /* Przygotowanie do odtwarzania i rozpoczęcie odtwarzania. */
      if ([self.audioPlayer prepareToPlay] &&
          [self.audioPlayer play]){
        NSLog(@"Rozpoczęto odtwarzanie zarejestrowanej treści audio.");
      } else {
        NSLog(@"Nie udało się odtworzyć treści audio.");
      }
      
    } else {
      NSLog(@"Nie udało się utworzyć odtwarzacza treści audio.");
    }
    
  } else {
    NSLog(@"Nie udało się zatrzymać procesu nagrywania.");
  }
  
  /* W tym momencie nie potrzebujemy już odtwarzacza treści audio. */
  self.audioRecorder = nil;
  
}

- (void) stopRecordingOnAudioRecorder
         :(AVAudioRecorder *)paramRecorder{
  
  /* W tym miejscu po prostu zatrzymujemy nagrywanie treści audio. */
  [paramRecorder stop];
  
}

- (NSDictionary *) audioRecordingSettings{
  
  NSDictionary *result = nil;
  
  /* Przygotowanie słownika zawierającego opcje dla obiektu nagrywającego treść audio. 
   Następnie słownik ten zostanie wykorzystany podczas tworzenia obiektu nagrywającego
   treść audio, który jest typu AVAudioRecorder. */
  
  NSMutableDictionary *settings = [[NSMutableDictionary alloc] init];
  
  [settings 
   setValue:[NSNumber numberWithInteger:kAudioFormatAppleLossless]
   forKey:AVFormatIDKey];
  
  [settings 
   setValue:[NSNumber numberWithFloat:44100.0f]
   forKey:AVSampleRateKey];
  
  [settings 
   setValue:[NSNumber numberWithInteger:1]
   forKey:AVNumberOfChannelsKey];
  
  [settings 
   setValue:[NSNumber numberWithInteger:AVAudioQualityLow]
   forKey:AVEncoderAudioQualityKey];
  
  result = [NSDictionary dictionaryWithDictionary:settings];
  
  return result;
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  NSError   *error = nil;
  
  NSString *pathAsString = [self audioRecordingPath];
  
  NSURL *audioRecordingURL = [NSURL fileURLWithPath:pathAsString];
  
  self.audioRecorder = [[AVAudioRecorder alloc] 
                        initWithURL:audioRecordingURL
                        settings:[self audioRecordingSettings]
                        error:&error];
  
  if (self.audioRecorder != nil){
    
    self.audioRecorder.delegate = self;
    /* Przygotowanie obiektu nagrywającego, a następnie rozpoczęcie nagrania. */
    
    if ([self.audioRecorder prepareToRecord] &&
        [self.audioRecorder record]){
      NSLog(@"Udało się rozpocząć nagrywanie.");
      
      /* Po pięciu sekundach proces nagrywania powinien zostać zatrzymany. */
      [self performSelector:@selector(stopRecordingOnAudioRecorder:)
                 withObject:self.audioRecorder
                 afterDelay:5.0f];
      
    } else {
      NSLog(@"Nie udało się przeprowadzić nagrania.");
      self.audioRecorder = nil;
    }
    
  } else {
    NSLog(@"Nie udało się utworzyć obiektu nagrywającego treść audio.");
  }
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  
  if ([self.audioRecorder isRecording]){
    [self.audioRecorder stop];
  }
  self.audioRecorder = nil;
  
  
  if ([self.audioPlayer isPlaying]){
    [self.audioPlayer stop];
  }
  self.audioPlayer = nil;
  
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
